
#comments-start

Glosspaste 1.0

This is a script for inserting glossary items with a keyboard shortcut.

It requires three things:
* you gotta have Clip-o-matic installed
* you gotta have your glossary pane top left of the screen (see screenshots)
* you gotta use "Tab" to advance

When you use the script, the way to move to the next segment is Ctrl+Enter.

#comments-end

#include <Array.au3>

Global $split

MsgBox (0, "How to use Glosspaste 1.0", "1. Have glossary pane top left" & @CRLF & "2. Have OmegaT in top left of screen" & @CRLF & "3. Have TAB to advance" & @CRLF & @CRLF & "Ctrl+Enter to advance" & @CRLF & "Ctrl+Shift+z, number (to select number)" & @CRLF & "Ctrl+Shift+x (to cancel Ctrl+Shift+z)" & @CRLF & "Ctrl+Shift+c (to dismiss tooltip once)", 60)

HotKeySet("^{ENTER}", "Nextseg")
HotKeySet("^+z", "Insert")
HotKeySet("^+x", "Uninsert")
HotKeySet("^+c", "Dismiss")

While 1
    Sleep("100")
WEnd

Func Dismiss()
ToolTip("") 
EndFunc

Func Nextseg()

ToolTip("") 

WinWaitActive ("OmegaT", "")

Send ("{TAB}")

MouseClick ("left", 150, 150, 1, 0)

Send ("^a")
Send ("^c")

$clip = ClipGet()

Send ("{TAB}")

$split = StringSplit ($clip, "'", 0)

For $i = 1 to 37
_ArrayAdd($split, " ")
Next

; TrayTip ("Glossary terms", "Shift+Ctrl+Z, then number:" & @CRLF & @CRLF & "1. " & $split[4] & @CRLF & "2. " & $split[8] & @CRLF & "3. " & $split[12] & @CRLF & "4. " & $split[16] & @CRLF & "5. " & $split[20] & @CRLF & "6. " & $split[24] & @CRLF & "7. " & $split[28] & @CRLF & "8. " & $split[32] & @CRLF & "9. " & $split[36] & @CRLF &  @CRLF & "Or Shift+Ctrl+X to cancel.", 20)

ToolTip ("Shift+Ctrl+Z, then number:" & @CRLF & @CRLF & "1. " & $split[4] & @CRLF & "2. " & $split[8] & @CRLF & "3. " & $split[12] & @CRLF & "4. " & $split[16] & @CRLF & "5. " & $split[20] & @CRLF & "6. " & $split[24] & @CRLF & "7. " & $split[28] & @CRLF & "8. " & $split[32] & @CRLF & "9. " & $split[36] & @CRLF &  @CRLF & "Or Shift+Ctrl+X to cancel.", 20, 70, "Glosspaste 1.0")

WinActivate ("OmegaT")

HotKeySet("1")
HotKeySet("2")
HotKeySet("4")
HotKeySet("5")
HotKeySet("6")
HotKeySet("7")
HotKeySet("8")
HotKeySet("9")

EndFunc

Func Uninsert()

HotKeySet("1")
HotKeySet("2")
HotKeySet("4")
HotKeySet("5")
HotKeySet("6")
HotKeySet("7")
HotKeySet("8")
HotKeySet("9")

EndFunc

Func Insert()

HotKeySet("1", "one")
HotKeySet("2", "two")
HotKeySet("3", "three")
HotKeySet("4", "four")
HotKeySet("5", "five")
HotKeySet("6", "six")
HotKeySet("7", "seven")
HotKeySet("8", "eight")
HotKeySet("9", "nine")

EndFunc

Func one()
Send ($split[4])
HotKeySet("1")
HotKeySet("2")
HotKeySet("4")
HotKeySet("5")
HotKeySet("6")
HotKeySet("7")
HotKeySet("8")
HotKeySet("9")
EndFunc

Func two()
Send ($split[8])
HotKeySet("1")
HotKeySet("2")
HotKeySet("4")
HotKeySet("5")
HotKeySet("6")
HotKeySet("7")
HotKeySet("8")
HotKeySet("9")
EndFunc

Func three()
Send ($split[12])
HotKeySet("1")
HotKeySet("2")
HotKeySet("4")
HotKeySet("5")
HotKeySet("6")
HotKeySet("7")
HotKeySet("8")
HotKeySet("9")
EndFunc

Func four()
Send ($split[16])
HotKeySet("1")
HotKeySet("2")
HotKeySet("4")
HotKeySet("5")
HotKeySet("6")
HotKeySet("7")
HotKeySet("8")
HotKeySet("9")
EndFunc

Func five()
Send ($split[20])
HotKeySet("1")
HotKeySet("2")
HotKeySet("4")
HotKeySet("5")
HotKeySet("6")
HotKeySet("7")
HotKeySet("8")
HotKeySet("9")
EndFunc

Func six()
Send ($split[24])
HotKeySet("1")
HotKeySet("2")
HotKeySet("4")
HotKeySet("5")
HotKeySet("6")
HotKeySet("7")
HotKeySet("8")
HotKeySet("9")
EndFunc

Func seven()
Send ($split[28])
HotKeySet("1")
HotKeySet("2")
HotKeySet("4")
HotKeySet("5")
HotKeySet("6")
HotKeySet("7")
HotKeySet("8")
HotKeySet("9")
EndFunc

Func eight()
Send ($split[32])
HotKeySet("1")
HotKeySet("2")
HotKeySet("4")
HotKeySet("5")
HotKeySet("6")
HotKeySet("7")
HotKeySet("8")
HotKeySet("9")
EndFunc

Func nine()
Send ($split[36])
HotKeySet("1")
HotKeySet("2")
HotKeySet("4")
HotKeySet("5")
HotKeySet("6")
HotKeySet("7")
HotKeySet("8")
HotKeySet("9")
EndFunc
