;
; AutoIt Version: 3.0
; Language: English
; Platform: Win9x/NT
; Author: Samuel Murray (leuce@...)
;
; Script Function:
; Does Find/Replace on an OmegaT TMX using jEdit and regex
;
; Requirements:
; AutoIt (obviously), jEdit, and your TMX file
;

; Ask for source lang code:

$SL = InputBox("Get SL", "What is the source language code (eg. EN-US)?", "", " M")

; Ask for target lang code:

$TL = InputBox("Get TL", "What is the target language code (eg. AF-ZA)?", "", " M")

; Ask for find phrase:

$FP = InputBox("Get Find Phrase", "Type in the phrase to find. To find whole words only, prepend with \< and append with \>.", "", " M")

; Ask for replace phrase:

$RP = InputBox("Get Replace Phrase", "Type in the phrase to replace with.", "", " M")

WinActivate ("jEdit", "")
WinWaitActive ("jEdit", "")

Send ("^f")

$CP1 = ('("' & $TL & '">)(\n.+)(' & $FP & ')(.+)(\n.+\n.+\n.+\n.+)("' & $SL & '")')

ClipPut ($CP1)

Send ("^v")
Send ("{TAB}")

$CP2 = ('$1$2' & $RP & '$4$5$6')

ClipPut ($CP2)

Send ("^v")

Send ("!a")

; Script ends.