#include <Array.au3>

#cs

WfTM2anon

A small utility to change the user ID (and optionally languages) of a WF TM.

A WF TM is a tab delimited file, in which the second column is the user ID, the fourth column is the source language code and the sixth colum is the target language code.  The last three columns are for extra information, so we can write the old user ID into the last column and be 51% certain that we're not overwriting anything crucial.  A line with too many tabs will not break the WF TM -- extra columns are simply ignored.

A WF TM is in UTF16-LE.  The first line is the header, which can be rewritten as-is.

#ce

$j = 0

; 1. Get the file names etc, and make backup file.

$wftmOLDfileopendialog = FileOpenDialog ("Select Wordfast TM", @ScriptDir, "Text files (*.txt)|All (*.*)")
$wftmOLDfileopen = FileOpen ($wftmOLDfileopendialog, 32) ; 32 = UTF16LE read&write
$wftmfileread = FileRead ($wftmOLDfileopen)

$wftmfileopen = FileOpen ($wftmOLDfileopendialog & "_new.txt", 34)

FileClose ($wftmOLDfileopendialog)

; 2. Ask user for various information

$newuserid = InputBox ("Type new user ID", "To which user ID should all entries be changed?  Press Cancel to not change the user IDs.", "CLIENT")
; if $newuserid = 2 then cancel

$undeleter = MsgBox (260, "Undelete deleted entries?", "Undelete deleted entries?", 0) ; 4 = yes/no button, 256 = no button is default, 4+256=260
; if $undeleter = 6 then yes

$sourcelanger = 0
$sourcelangermsg = MsgBox (260, "Change source language?", "Change source language of all entries?", 0)
If $sourcelangermsg = 6 Then
$sourcelanger = InputBox ("Type new source language code", "To which source language code should all entries be changed?  Press Cancel to not change the source language.", "EN-ZA")
; if $sourcelanger = 2 then cancelled
EndIf

$targetlanger = 0
$targetlangermsg = MsgBox (260, "Change target language?", "Change target language of all entries?", 0)
If $targetlangermsg = 6 Then
$targetlanger = InputBox ("Type new target language code", "To which target language code should all entries be changed?  Press Cancel to not change the target language.", "AF-ZA")
; if $targetlanger = 2 then cancelled
EndIf

; 3. Start splitting the TM and writing entries

$wftmfilelines = StringSplit ($wftmfileread, @CRLF, 1)

If @error = 1 Then
MsgBox (0, "Error splitting Wordfast TM file", "The Wordfast TM file appears to be empty. Please roll back the TM from the backup file.", 0)
Exit
EndIf

; Write header line to output file
FileWrite ($wftmfileopen, $wftmfilelines[1] & @CRLF)

For $i = 2 to $wftmfilelines[0]

$wftmfiletabs = StringSplit ($wftmfilelines[$i], @TAB, 1)
If @error = 1 Then ; then write the line as-is back to the TM, plus "!"
FileWrite ($wftmfileopen, "! " & $wftmfilelines[$i] & @CRLF)
ContinueLoop
EndIf

If $newuserid <> 2 Then ; then change the user ID
$olduserid = $wftmfiletabs[2]
$wftmfiletabs[2] = $newuserid
_ArrayAdd($wftmfiletabs, $olduserid)
EndIf

If $undeleter = 6 Then ; then undelete, please
If StringLeft ($wftmfiletabs[1], 2) = "xx" Then ; then it's a deleted entry
$wftmfiletabs[1] = StringReplace ($wftmfiletabs[1], "xx", "20", 1)
EndIf
EndIf

If $sourcelangermsg = 6 Then
If $sourcelanger <> 2 Then ; then change source language
$wftmfiletabs[4] = $sourcelanger
EndIf
EndIf

If $targetlangermsg = 6 Then
If $targetlanger <> 2 Then ; then change target language
$wftmfiletabs[6] = $targetlanger
EndIf
EndIf

$wftmfilelines[$i] = _ArrayToString($wftmfiletabs, @TAB, 1)

FileWrite ($wftmfileopen, $wftmfilelines[$i] & @CRLF)

$j = $j + 1

Next

MsgBox (0, "Done!", "Processed " & $j + 1 & " lines (including header line).", 0)
