
MsgBox (0, "File Enumerator v 0.1", "Thank you for using File Enumerator." & @CRLF & @CRLF & "Usage:" & @CRLF & "1. Open the folder with the files to be enumerated" & @CRLF & "2. Highlight the file to be enumerated" & @CRLF & "3. Press Ctrl+/ (Ctrl + forwardslash) to enumerate" & @CRLF & "4. Highlight next file to be enumerated" & @CRLF & "5. Press Ctrl+/ again" & @CRLF & "6. Repeat steps 4 and 5 until you're done" & @CRLF & @CRLF & "* To start the numbering at a certain number again, press Ctrl+Shift+/" & @CRLF & "* FileEnum does not enumerate above 1000" & @CRLF & "* To exit, press Ctrl+Q" & @CRLF & @CRLF & "(c) 2007 Samuel Murray, Creative Commons BY-SA" & @CRLF & "Press Ctrl+Shift+Q for source code in 7z format")

Global $num = 1

HotKeySet("^/", "RenameFile")
HotKeySet("^+/", "NewNum")
HotKeySet("^q", "ExitProgram")
HotKeySet("^+q", "ExtractSource")

While 1
    Sleep(100)
WEnd

Func RenameFile()

Send ("!f")
Send ("m")

Send ("^c")

$origname = ClipGet()

If $num < 10 Then
$newname = "00" & $num & " " & $origname
ElseIf $num < 100 Then
$newname = "0" & $num & " " & $origname
ElseIf $num > 99 Then
$newname = $num & " " & $origname
EndIf

$num = $num + 1

ClipPut($newname)

Send ("^v")
Send ("{ENTER}")

EndFunc

Func NewNum ()

$newnum1 = InputBox ("Resetting the numbering", "Type the number at which you'd like FileEnum to begin from (without the leading zeros)")

$num = $newnum1

EndFunc

Func ExitProgram()
Exit
EndFunc

Func ExtractSource()
FileInstall("FileEnum_src.7z", "FileEnum_src.7z")
EndFunc
